' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class Login
  Inherits System.Web.UI.Page

  Protected Sub Login1_Authenticate(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.AuthenticateEventArgs)
    If Roles.Enabled = False Then
      ' Przeprowad wasne uwierzytelnienie wzgldem bazy danych Access.
      Dim userName As String = Login1.UserName
      Dim passwordHash As String = FormsAuthentication.HashPasswordForStoringInConfigFile(Login1.Password, "MD5")
      Dim userRoles As ArrayList = UserManager.GetUserRoles(userName, passwordHash)

      If userRoles IsNot Nothing Then
        Dim userData As String = String.Empty
        For Each myRole As String In userRoles
          userData &= myRole & ","
        Next

        ' Wytnij ostani przecinek
        userData = userData.TrimEnd(","c)

        Dim ticket As New FormsAuthenticationTicket( _
         2, _
         userName, _
         System.DateTime.Now, _
         System.DateTime.Now.AddMinutes(30), _
         Login1.RememberMeSet, _
         userData, _
         FormsAuthentication.FormsCookiePath)

        ' Zakoduj bilet.
        Dim encTicket As String = FormsAuthentication.Encrypt(ticket)

        ' Utwrz ciasteczko.
        Response.Cookies.Add(New HttpCookie(FormsAuthentication.FormsCookieName, encTicket))

        ' przenie z powrotem do pocztkowego URL.
        Response.Redirect(FormsAuthentication.GetRedirectUrl(userName, True))
      Else
        e.Authenticated = False
      End If
    End If
  End Sub

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Page.IsPostBack AndAlso Roles.Enabled = False Then
      AddHandler Login1.Authenticate, AddressOf Login1_Authenticate
    End If
  End Sub
End Class
